package tv.own.validators
{
	import mx.validators.StringValidator;
	import mx.validators.ValidationResult;
	
	public class DefaultTextStringValidator extends StringValidator
	{
		
		public var defaultText:String;
		
		
		/**
		 *  @private
		 *  Storage for the defaultTextError property.
		 */
		private var _defaultTextError:String;
		
		[Inspectable(category="Errors", defaultValue="null")]
		
		/** 
		 *  Error message when the String matches the default value
		 *
		 *  @default "Please enter a unique value"
		 *  
		 *  @langversion 3.0
		 *  @playerversion Flash 9
		 *  @playerversion AIR 1.1
		 *  @productversion Flex 3
		 */
		public function get defaultTextError():String 
		{
			return _defaultTextError;
		}
		
		public function set defaultTextError(value:String):void
		{			
			_defaultTextError = value != null ? value :"Please enter a unique value";
		}
		
		public function DefaultTextStringValidator()
		{
			//TODO: implement function
			super();
		}
		
		
		
		override protected function doValidation(value:Object):Array
		{
			var results:Array = [];
			results = super.doValidation(value);
			
			if(value.toString() == defaultText) {
				results.push(new ValidationResult(true, null, "defaultText", defaultTextError)); 
			}
			
			
			
			return results;
			
		}
		
	}
}