package tv.own.util
{
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	import mx.collections.ArrayCollection;
	import mx.collections.XMLListCollection;
	
	import tv.own.events.ConfigEvent;
	import tv.own.gratitude.model.Model;
	import tv.own.gratitude.vo.PromoLinkVO;
	import tv.own.gratitude.vo.SponsorItemVO;
	
	[Bindable]
	public class Config extends EventDispatcher
	{
		private static var _instance:Config;
		
		private var _params:Object;
		
		private const DEFAULT_CONFIG_URL:String = "xml/wog_config.xml";
		
		private var model:Model = Model.getInstance();
		
		public function initConfig(flashvars:Object):void
		{
			dispatchEvent(new ConfigEvent(ConfigEvent.LOADING));
			//Define default parameters passed via FlashVars
			_params = (flashvars)?flashvars:{};
			var path:String = (flashvars.config)?String(flashvars.config):DEFAULT_CONFIG_URL;
			//Load XML if it exists
			if(path) {
				var req:URLRequest = new URLRequest(path);
				var loader:URLLoader = new URLLoader();
				loader.addEventListener(Event.COMPLETE, loadHandler);
				loader.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
				loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorHandler);
				loader.load(req);
			} else {
				
			}
			
			//Load SharedObject as last step to define app parameters 
			
		}
		public function get params():Object
		{
			return _params;
		}
		
		
		
		
		private var _appGradients:ArrayCollection = new ArrayCollection(new Array(0x70749D,0x6E729D,0x44456F));
		
		public function set appGradients(value:ArrayCollection):void
		{
			_appGradients = value;
		}
		public function get appGradients():ArrayCollection
		{
			return _appGradients;
		}
		
		private function initValues(xml:XML):void
		{
			var arr:Array =[];
			arr.push(uint(xml.theme.appGradient1), uint(xml.theme.appGradient2), uint(xml.theme.appGradient3));
			appGradients = new ArrayCollection(arr);
			var arr2:Array = [];
			for( var i:uint = 0; i<xml.sponsors.promo.length(); i++) {
				var node:XML = xml.sponsors.promo[i];
				var links:Array = [];
				for ( var j:uint = 0; j<node.link.length(); j++) {
					var link:XML = node.link[j];
					var linkVO:PromoLinkVO = new PromoLinkVO(String(link), String(link.@href), (link.@bullet=="true"), String(link.@target));
					links.push(linkVO);
				}
						
				var vo:SponsorItemVO = new SponsorItemVO(String(node.title),String(node.description),String(node.@img), String(node.@header), links);
				arr2.push(vo);
			}
			model.helpTextNode = xml.panel.(@id=='welcome')[0].help[0];
			model.sponsorCollection = new ArrayCollection(arr2);
			model.footerCollection = new XMLListCollection(xml.footer.item);
			
		}
		
		
		
		private function loadHandler(e:Event):void
		{
			_params.xml = new XML(e.target.data);
			model.configXML = new XML(e.target.data);
			initValues(_params.xml);
			dispatchEvent(new ConfigEvent(ConfigEvent.LOADED));
		}
		
		private function errorHandler(e:ErrorEvent):void
		{
			dispatchEvent(new ConfigEvent(ConfigEvent.FAILED));
		}
		
		
		
		/**
		 *
		 * @param val Object to strongType.
		 * @return The original value in the correct primitive type.
		 **/
		public static function strongType(val:*):Object {			
			if (val==null) {
				return null;
			}
			else if (val is Array) {
				return val;
			} 
			else if (val == "null") {
				return null;
			} else if (val == 'true') {
				return true;
			} else if (val == 'false') {
				return false;
			} else if (isNaN(Number(val))) {
				return String(val);
			} else {
				return Number(val);
			}
		}
		
		
		
		
		public static function getInstance():Config
		{
			if (! _instance)
			{
				_instance = new Config(new SingletonEnforcer());
			}
			return _instance;
			
		}
		public function Config(s:SingletonEnforcer){}
	}
}
class SingletonEnforcer{}    