package tv.own.util
{
	import com.gskinner.utils.Rndm;
	
	import flash.geom.Point;

	public class CircleUtil
	{
		           
                  public var x:Number;
                  public var y:Number;
                  public var radius:Number;
                 
                  public function CircleUtil(x:Number, y:Number, radius:Number) {        
                           this.x = x;
                           this.y = y;
                           this.radius = radius;
                  }
                 
                  public function circleExists(objX:Number, objY:Number, objRadius:Number):Boolean {
                           // find out if a smaller circle exists within the bounds of this circle
                           var dist:Number = Math.sqrt( Math.pow(objX, 2) + Math.pow(objY, 2) );
                           return Boolean(Math.ceil(dist) <= radius-objRadius);
                  }
                 
                  public function getPointInRange(minAngle:Number,maxAngle:Number,minRadius:Number,maxRadius:Number):Point {
                           // fetches a point within given params. This isn't tied to this circle radius specifically
                           var p:Point = new Point();
                           var a:Number = (Math.random()*(maxAngle-minAngle)) + minAngle;
                           var r:Number = (Math.random()*(maxRadius-minRadius))  + minRadius;
                           p.x = Math.cos(a * Math.PI/180) * r;
                           p.y = Math.sin(a * Math.PI/180) * r;
                           return p;
                  }
                 
                  public function getRandomPoint(maxRadius:Number):Point {
                           // fetches a random point within this circle radius
                           var p:Point = new Point();
                           var a:Number = (Rndm.random()*360);
                           var r:Number = (Rndm.random()*maxRadius);
                           p.x = Math.cos(a * Math.PI/180) * r;
                           p.y = Math.sin(a * Math.PI/180) * r;
                           return p;
                  }
         }

		
	
}