package tv.own.gratitude.snow
{
	import flash.display.MovieClip;
	         import flash.display.Sprite;
	         import flash.events.Event;
	         import flash.events.MouseEvent;
	         import flash.geom.Rectangle;
	         import flash.geom.Point;
	        
	         public class SnowGlobeContainer extends Sprite {
		                 
		                  public var snowForeground:SnowGeneratorCircle;
		                  public var snowBackground:SnowGeneratorCircle;
		                  public var cursor:MovieClip;               
		                  public var drag:Boolean = false;                 
		                  public var over:Boolean = false;        
		                  public var startPos:Point = new Point;
		                  public var mouseDownOffset:Point = new Point;
		                  public var bounds:Rectangle = new Rectangle;               
		                  public var vel:Point = new Point(0,0);
		                  public var pos:Point = new Point(x,y);
		                  public var old:Point = new Point(x,y);
		                  public var gravity:Number = 5+(Math.random()*1);
		                  public var restitution:Number = 0.5;
		                  public var friction:Number = 0.9;        
		        
		                  public function SnowGlobeContainer() {        
			                           // save some initial persistant properties     
			                           startPos.x = this.x;
			                           startPos.y = this.y;
			                           old.x = this.x;
			                           old.y = this.y;
			                           bounds.x = 0;
			                           bounds.y = 0;
			                           bounds.width = 600;
			                           bounds.height = startPos.y;              
			                           // add mouse interaction listeners and show the cursor on rollover
			                           this.mouseChildren = false;
			                           this.useHandCursor = true;
			                           this.buttonMode = true;
			                           this.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			                           this.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			                           this.addEventListener(Event.ENTER_FRAME, update);
		                  }
		                 
		                  protected function onMouseOver(e:MouseEvent=null):void { over = true; }
		                 
		                  protected function onMouseOut(e:MouseEvent=null):void {  over = false; }
		                 
		                  protected function onMouseDown(e:MouseEvent=null):void {
			                           // Save the offset of your mouse when you first start dragging. Same functionality as startDrag(false)
			                           mouseDownOffset.x = mouseX;
			                           mouseDownOffset.y = mouseY;
			                           drag = true;
		                  }
		                 
		                  protected function onMouseUp(e:MouseEvent=null):void {
			                           vel.x = vel.y = 0;
			                           pos.x = x;
			                           pos.y = y;
			                           drag = false; 
		                  }
		                 
		                  public function update(e:Event):void {
			                           // this if/else statement controls the mouse over and out instead of using event listeners
			                           if(mouseY < -175 || mouseY > 175 || mouseX < -175 || mouseX > 175){
				                                    if(over) onMouseOut();
			                           }else{
				                                    if(!over) onMouseOver();
			                           }
			                                            
			                           if(drag){
				                                    // drag around..
				                                    this.x = parent.mouseX - mouseDownOffset.x;
				                                    this.y = parent.mouseY - mouseDownOffset.y;
				                                    // keep this thing on the table :)
				                                    if(y >= bounds.height) y = bounds.height;
				                                    // if you "shake" or move the mouse quickly, we are going to reset the snow particles
				                                    var d:Point = new Point(Math.abs(old.x - x), Math.abs(old.y - y));
				                                    if(d.x > 50 || d.y > 50 ){
					                                             snowForeground.reset();
					                                             snowBackground.reset();
				                                    }                         
				                                    // update the history position   
				                                    old.x = x;
				                                    old.y = y;                               
				                                    vel.y = (y-old.y)/2;
			                           }else{
				                                    // if you drop this object it should have a bit of realistic falling..
				                                    vel.y += gravity;
				                                    pos.y += vel.y;                                         
				                                    // bounce
				                                    if(pos.y > bounds.height){
					                                             pos.y = bounds.height;
					                                             vel.y *= -(Math.random()*restitution);
				                                    }
				                                    y = pos.y;
			                           }
		                  }
	         }
}