package tv.own.gratitude.snow
{
import com.greensock.TweenLite;
import com.gskinner.utils.Rndm;

import flash.display.Shape;
import flash.filters.BlurFilter;
import flash.geom.Point;

import tv.own.util.CircleUtil;

        
         public class SnowFlake extends Shape
         {
                  public var vel:Point = new Point;
                  public var radius:Number = 10;
                  public var circle:CircleUtil = new CircleUtil(0,0,278);
                 
                  public function SnowFlake() {    
                           // draw snowflake           
                           graphics.lineStyle(3,0xffffff);
                           graphics.moveTo(0,0);
                           graphics.lineTo(0.2,0.2);         
                           // place the snowflake randomly
                           var p:Point = circle.getRandomPoint( circle.radius - this.radius );                          
                           this.x = p.x;
                           this.y = p.y;
                           // set a z "depth" index to give it some scale
                           var z:Number = (Math.random()*300)-150;                   
                           radius = calculatePerspectiveSize(z);           
                           scaleX = scaleY = radius;
                           // give our flake some depth of feild blur
                           if(z<-150) {
	                                    var bluramount:Number = z+150;                                 
	                                    bluramount /= -100;                                 
	                                    bluramount = (bluramount * 20) + 2; 
	                                    filters = [new BlurFilter(bluramount, bluramount, 2)];
                           } else  {
	                                    filters = [new BlurFilter(2,2,2)];
                           }
                           // cache this vector object as a bitmap so the flash player will render it faster
                           cacheAsBitmap = true;
                           // some velocity properties
                           vel.x = (Math.random()*2)-1;
                           vel.y = 1.5;
                           vel.x*=radius;
                           vel.y*=radius;
                  }
                 
                  public function reset():void{
                           // reset our snowflake to a new random position             
                           var p:Point = circle.getRandomPoint( circle.radius - this.radius );
                           this.x = p.x;
                           this.y = p.y;
                           if(this.y > circle.radius) this.y = 0;
						   TweenLite.to(this, Rndm.random(), {alpha:1});
                  }
                 
                  public function update(wind:Number):void {
                           // this function is called on an enter frame event from the Generator class
                           if( circle.circleExists(x,y,radius) && y < circle.radius ){
	                                    x+=vel.x;
	                                    y+=vel.y;
	                                    x += (wind*radius);
                           } else {
							TweenLite.to(this, Rndm.random(), {alpha:0});
							}
                  }
                 
                  public function calculatePerspectiveSize(z:Number) : Number {
                           var fov:Number = 300;                     
                           return fov/(z+fov);
                  }
         }       

}