package tv.own.gratitude.snow
{
	import com.greensock.TweenLite;
	import com.greensock.easing.Linear;
	import com.greensock.easing.Quad;
	
	import flash.display.MovieClip;
	
	import spark.core.SpriteVisualElement;
	
	
	public class RandomSnowGenerator extends SpriteVisualElement
	{
		// Debug
		private var tracer:Boolean = false; // If true, trace() windforce values in the output panel
		
		// Snow behavior
		private var intro:Boolean = true; // If true, the snowflakes will appear from the top left hand corner, instead of directly filling the screen.
		private var fade:Boolean = true; // If true, the snowflakes will appear using opacity
		
		// Snow Look
		public var snowAmount:int = 1500; // The number of snowflakes
		private var snowSize:Number = 1; // Scale of individual snowflakes. 1 is normal, 2 is double, 0.5 is half
		
		// Snow distance
		private var snowZmin:Number = 0; // The min snowflake distance : 0 is close, 1 is far
		private var snowZmax:Number = 1; // The max snowflake distance : 0 is close, 1 is far
		
		// Snow Opacity
		private var snowAlphaMin:Number = 0.1; // The minimum alpha value
		private var snowAlphaMax:Number = 1.3; // The maximum alpha value
		
		// Snow Rotation
		public var snowRotation:Number = 1 // Rotation animation. 0.5 is half, 2 is double.
		
		// Gravity
		public var gravity:int = 100; // Speed of fall. 100 is the normal speed. 0 to float, -100 to inverse the direction.
		
		// Wind Force
		private var windBegin:int = 200; // The inital wind when the snow starts, then it smoothly changes to the normal values
		private var windForceMin:int = 0; // The minimum force of the wind
		private var windForceMax:int = 400; // The maximum force of the wind
		
		
		// Wind Direction
		private var windDirection:String = "both"; // You can chose between "left", "right", and "both"
		
		// Wind duration
		private var windTimeMin:int = 1 // Minimum time between two winds
		private var windTimeMax:int = 6 // Maximum time between two winds      
		
		private var nWind:int
		private var wind:Object = new Object;  
		
		private var sw:int
		private var sh:int
		private var margin:int = 200;			
		private static const WIND_RIGHT:String = "right";
		private static const WIND_LEFT:String = "left";
		private static const WIND_BOTH:String = "both";
		
		private var windTween:TweenLite;
		
		public function RandomSnowGenerator()
		{
			super();
			sw = this.width;
			sh = this.height;
		}
		
		public function startSnow(intro:Boolean = false, fade:Boolean = true, amount:int = 1000, size:Number = 1, gravity:int = 100, windStart:int = 400, windForceMin:int = 0, windForceMax:int = 20, windDirection:String = "both", windTimeMinint:int = 1, windTimeMax:int = 6):void
		{
			this.intro = intro;
			this.fade = fade;
			this.snowAmount = amount;
			this.snowSize = size;
			this.gravity = gravity;
			this.windBegin = windStart;
			this.windForceMin = windForceMin;
			this.windForceMax = windForceMax;
			this.windDirection = windDirection;
			this.windTimeMin = windTimeMin;
			this.windTimeMax = windTimeMax;
			TweenLite.to(this, .5, {alpha:1});
			ok = true;
			windRandom();
			initSnow();
		}
		
		public function endSnow(duration:uint =5, delay:uint = 0, gravity:uint = 20, snowRotation:Number = .2):void
		{
			windTween.kill();
			windTween = new TweenLite(wind, duration, {delay:delay, force:0});
			TweenLite.to(this, duration, {snowAmount:0, snowRotation:snowRotation, gravity:gravity, delay:delay, onComplete:endSnowComplete});
		}
		
		private function endSnowComplete():void
		{
			trace("Tween Done");
			TweenLite.to(this, 1, {alpha:0});
		}
		
		private function windRandom():void {
			wind.max = windForceMax
			wind.min = windForceMin
			wind.dir = windDirection
			
			if(wind.dir == "right") {
				wind.force = windBegin
			} else if(wind.dir == "left") {
				wind.force = -windBegin
			} else {
				wind.force = windBegin
			}
			
			if(wind.dir == "right") {
				nWind = Math.random()*(wind.max-wind.min)+wind.min
			} else if(wind.dir == "left") {
				nWind = -Math.random()*(wind.max-wind.min)-wind.min
			} else {
				nWind = Math.random()*(wind.max*2-wind.min)-wind.min-wind.max
			}
			if(tracer == true) {
				trace("SNOW : next wind : "+nWind)
			}
			windTween = new TweenLite(wind, Math.random()*3+1, {force:nWind, delay:Math.random()*(windTimeMax-windTimeMin)+windTimeMin, onComplete:windRandom});
			windTween.play();
		}   
		
		private var ok:Boolean = true;
		
		private function initSnow():void {
			
			if(snowAmount >= 10000) {
				ok = false;
				trace("SNOW ALERT : too many snowflakes")
			}
			
			if(snowSize > 10) {
				ok = false;
				trace("SNOW ALERT : snowSize is too high")
			}
			
			if(snowZmin > snowZmax) {
				ok = false;
				trace("SNOW ALERT : snowZmin is superior to snowZmax")
			}
			
			if(windForceMin > windForceMax) {
				ok = false;
				trace("SNOW ALERT : 	windForceMin is superior to windForceMax")
			}
			
			if(snowAlphaMin > snowAlphaMax) {
				ok = false;
				trace("SNOW ALERT : 	snowAlphaMin is superior to snowAlphaMax")
			}
			
			if(windTimeMin > windTimeMax) {
				ok = false;
				trace("SNOW ALERT : 	windTimeMin is superior to 	windTimeMax")
			}
			
			if(ok == true) {
				for (var i:int=0; i<snowAmount; i++) {
					createSnow(i);
				}
			}
		}
		
		
		private function createSnow(i:int):void {
			var m:InactiveSnowflake = new InactiveSnowflake();
			m.mouseEnabled = false;
			
			if(intro == true) {
				m.y = Math.random() * - margin *2;
				m.x = Math.random() * (sw / 2 + margin) - margin * 2;
			} else {
				m.y = Math.random() * (sh + margin*2) - margin*2;
				m.x = Math.random() * (sw + margin*2) - margin*2;
			}
			
			m.rotation = Math.random() * 360;
			m.depth = Math.random() * (snowZmax*2-snowZmin) + snowZmin
			m.depth = int(m.depth*100)/100
			m.scaleX = m.scaleY = Math.max(0.4, (1/(Math.max(0, m.depth))-0.5)*snowSize)
			//trace("d : "+m.depth + " = scaleX " + m.scaleX)
			if(fade == true) {
				m.alpha = 0;
			} else {
				m.alpha = newAlpha(m);
			}
			addChild(m);
			snowX(m);
			snowY(m);
		}
		
		private var nAlpha:Number = 1;
		private function newAlpha(m:InactiveSnowflake):Number {
			if(m.scaleX < 2*snowSize) {
				nAlpha = (Math.random()*(snowAlphaMax-snowAlphaMin)+snowAlphaMin)
			} else if(m.scaleX > 2*snowSize && m.scaleX < 4*snowSize) {
				nAlpha = (Math.random()*(snowAlphaMax-snowAlphaMin)+snowAlphaMin)*0.6
			} else if(m.scaleX > 4*snowSize) {
				nAlpha = (Math.random()*(snowAlphaMax-snowAlphaMin)+snowAlphaMin)*0.4
			}
			return nAlpha;
		}
		
		private function snowX(m:InactiveSnowflake):void {
			xReset(m);
			TweenLite.to(m, Math.random()*2+1, {alpha:newAlpha(m), x:m.x+(Math.random()*80-40+wind.force)*(m.scaleX), rotation:String(Math.random()*snowRotation*900), onComplete:snowX, onCompleteParams:[m], ease:Quad.easeInOut, overwrite:false});
		}
		
		private function snowY(m:InactiveSnowflake):void {
			yReset(m);
			TweenLite.to(m, Math.random()*2+1, {y:m.y+(Math.random()*(gravity/2)+(gravity/2))*(m.scaleX)*3, onComplete:snowY, onCompleteParams:[m], ease:Linear.easeInOut, overwrite:false});
		}
		
		private function xReset(m:InactiveSnowflake):void {
			if (m.x > sw + margin) {
				m.x = Math.random() * -margin;
			} else 	if (m.x < -margin) {
				m.x = sw + Math.random() * margin;
			}
		}
		
		private function yReset(m:InactiveSnowflake):void {
			if (m.y > sh + margin) {
				m.y = Math.random() * -margin;
			} else if (m.y < -margin) {
				m.y = sh + Math.random() * margin;
			}
		}  
		
	}
}