package tv.own.gratitude.controller
{
	import com.facebook.graph.Facebook;
	import com.facebook.graph.data.FacebookSession;
	import com.greensock.TweenLite;
	
	import flash.events.EventDispatcher;
	import flash.external.ExternalInterface;
	import flash.net.URLVariables;
	
	import mx.collections.ArrayCollection;
	import mx.collections.XMLListCollection;
	import mx.core.IFlexDisplayObject;
	import mx.core.UIComponent;
	import mx.managers.PopUpManager;
	
	// import org.osmf.traits.ViewableTrait;
	
	import spark.components.Application;
	
	import tv.own.gratitude.business.AdManager;
	import tv.own.gratitude.business.AnalyticsManager;
	import tv.own.gratitude.business.Services;
	import tv.own.gratitude.components.core.ModalAlert;
	import tv.own.gratitude.events.AnalyticEvent;
	import tv.own.gratitude.events.ModelEvent;
	import tv.own.gratitude.events.ServiceEvent;
	import tv.own.gratitude.events.ViewEvent;
	import tv.own.gratitude.model.Model;
	import tv.own.gratitude.vo.StatementVO;
	import tv.own.gratitude.vo.UserVO;
	import tv.own.util.Config;
	import tv.own.vo.CountryListVO;
	
	[Event(name="viewCreatePanel", type="tv.own.gratitude.events.ViewEvent")]
	[Event(name="viewShake", type="tv.own.gratitude.events.ViewEvent")]
	[Event(name="viewShowStatement", type="tv.own.gratitude.events.ServiceEvent")]
	
	[Bindable]
	public class Controller extends EventDispatcher
	{
		private static var _instance:Controller;
		
		private var service:Services = Services.getInstance();
		private var model:Model = Model.getInstance();
		private var config:Config = Config.getInstance();
		private var ads:AdManager;
		private var analytics:AnalyticsManager;
		private var _app:Application;
		private var modal:IFlexDisplayObject;
		
		public function init(app:Application):void
		{
			var arr:Array = [];
			for (var i:uint = 0; i<Model.COUNTRIES.country.length(); i++) {
				var node:XML = Model.COUNTRIES.country[i];
				var vo:CountryListVO = new CountryListVO(i, String(node), String(node.@code));
				arr.push(vo);
			}
			model.countryList = new ArrayCollection(arr);
			
			
			model.gateway = config.params.gateway?config.params.gateway:Services.DEBUG_CGI;
			this._app = app;
			ads = new AdManager();
			analytics = new AnalyticsManager();
			var str:String = ExternalInterface.call("eval", "getCookie('AUTH')");
			if(str) {				
			model.auth = str;
			}
			//config.params.statementId = 168;
			if(config.params.statementId) {
				getStatement(config.params.statementId);
			}
			getCountryList();	
			
			model.addEventListener(ModelEvent.HELP_TOGGLE, helpToggleHandler);
			
		}
		
		private function helpToggleHandler(e:ModelEvent):void
		{
			if(e.data == true) {
				this.dispatchEvent(new AnalyticEvent(AnalyticEvent.HELP));
			}
		}
		
		
		public function get app():Application {
			return _app;
		}
		
		protected function getCountryList():void
		{
			service.addEventListener(ServiceEvent.GET_COUNTRY_LIST_LOADING, countryLoadingHandler);
			service.addEventListener(ServiceEvent.GET_COUNTRY_LIST_LOADED, countryLoadedHandler);
			service.addEventListener(ServiceEvent.GET_COUNTRY_LIST_ERROR, countryErrorHandler);
			service.getCountryList();
		}
		
		//User Messaging
		public function showModalAlert(msg:String, state:String = "alert", title:String = "", w:Number = 350, h:Number = 200):void
		{
			if(modal) {
				PopUpManager.removePopUp(modal);
			}
			var rb:ModalAlert = new ModalAlert();
			rb.currentState = state;
			rb.width = w;
			rb.height = h;
			rb.message = msg;
			rb.title = title;
			modal = rb;
			PopUpManager.addPopUp(rb, app, true);
			rb.x = Math.floor((app.width-rb.width)/2);
			rb.y = Math.floor((app.height-rb.height)/2);
		} 
		
		public function getFacebookUser():void
		{
			service.addEventListener(ServiceEvent.GET_FACEBOOK_USER_LOADING, facebookUserLoadingHandler);
			service.addEventListener(ServiceEvent.GET_FACEBOOK_USER_LOADED, facebookUserLoadedHandler);
			service.addEventListener(ServiceEvent.GET_FACEBOOK_USER_NONE, facebookUserNoneHandler);
			service.addEventListener(ServiceEvent.GET_FACEBOOK_USER_ERROR, facebookUserErrorHandler);
		}
		
		
		public function getOcomUser():void
		{
			service.addEventListener(ServiceEvent.GET_OCOM_USER_LOADING, ocomUserLoadingHandler);
			service.addEventListener(ServiceEvent.GET_OCOM_USER_LOADED, ocomUserLoadedHandler);
			service.addEventListener(ServiceEvent.GET_OCOM_USER_NONE, ocomUserNoneHandler);
			service.addEventListener(ServiceEvent.GET_OCOM_USER_ERROR, ocomUserErrorHandler);
			service.getUserInfo();
		}
		
		public function getStatement(id:uint):void
		{
			service.addEventListener(ServiceEvent.GET_STATEMENT_LOADING, statementLoadingHandler);
			service.addEventListener(ServiceEvent.GET_STATEMENT_LOADED, statementLoadedHandler);
			service.addEventListener(ServiceEvent.GET_STATEMENT_UNAVAILABLE, statementUnavailableHandler);
			service.addEventListener(ServiceEvent.GET_STATEMENT_ERROR, statementErrorHandler);
			service.getStatement(id);
		}
		
		public function getStatementList(type:String = "random", limit:uint = 40):void
		{
			service.addEventListener(ServiceEvent.GET_STATEMENT_LIST_LOADING, statementListLoadingHandler);
			service.addEventListener(ServiceEvent.GET_STATEMENT_LIST_LOADED, statementListLoadedHandler);
			service.addEventListener(ServiceEvent.GET_STATEMENT_LIST_ERROR, statementListErrorHandler);
			service.getStatements(type, limit);
		}
		
		public function addStatement(vo:StatementVO):void
		{
			if(vo.user.type ==UserVO.OCOM) {
				dispatchEvent(new AnalyticEvent(AnalyticEvent.SUBMIT_LOGGED_IN));
			} else {
				dispatchEvent(new AnalyticEvent(AnalyticEvent.SUBMIT_NOT_LOGGED_IN));
			}
			service.addEventListener(ServiceEvent.SUBMIT_STATEMENT_LOADING, submitPendingHandler);
			service.addEventListener(ServiceEvent.SUBMIT_STATEMENT_LOADED, submitSuccessHandler);
			service.addEventListener(ServiceEvent.SUBMIT_STATEMENT_ERROR, submitErrorHandler);
			service.submitStatement(vo);
		}
		
		
		/* UI API */
		public function uiAddStatement(fromTopButton:Boolean):void
		{
			if(model.submitCount>0) {
				dispatchEvent(new AnalyticEvent(AnalyticEvent.CREATE_ANOTHER2));
			} else {
				if(fromTopButton) {
					dispatchEvent(new AnalyticEvent(AnalyticEvent.CREATE_ANOTHER1));
				} else {
					dispatchEvent(new AnalyticEvent(AnalyticEvent.CREATE_NEW));
				}
			}
			dispatchEvent(new ViewEvent(ViewEvent.VIEW_CREATE_PANEL));
		}
		
		public function uiShakeView():void
		{
			dispatchEvent(new ViewEvent(ViewEvent.VIEW_SHAKE));
			getStatementList();
		}
		
		public function uiSkipInterstitialAd():void
		{
			model.showInterstitial = false;
			dispatchEvent( new AnalyticEvent(AnalyticEvent.SKIP_AD));
			//dispatchEvent(new ServiceEvent(ServiceEvent.SUBMIT_STATEMENT_LOADED));
		}
		public function uiHomeClick():void
		{
			dispatchEvent(new ViewEvent(ViewEvent.HOME_CLICK));
		}
		
		public function uiShareStatement():void
		{
			//Setup this js listener to handle users that need to authenticate and login.
			//The first loginHandler will come back null so we need to handle this one as well.
			Facebook.addJSEventListener('auth.sessionChange', loginPromptHandler);
			initHandlerHasRun = postHasBeenCalled = false;
			dispatchEvent( new AnalyticEvent(AnalyticEvent.SHARE_WITH_FACEBOOK));
			Facebook.init("124147657643316", initHandler);
			var node:XML = model.configXML.messages.message.(@id=="facebookLoading")[0];
			showModalAlert(node, "alert", node.@title);
		}
		
		
		
		/* End of UI API*/
		
		/*  <Service Status/Result Handlers>  */
		/*  Country List */
		private function countryLoadingHandler(e:ServiceEvent):void
		{
			dispatchEvent(e);
		}
		private function countryLoadedHandler(e:ServiceEvent):void
		{
			model.countryList = new ArrayCollection(e.data as Array);
		}
		private function countryErrorHandler(e:ServiceEvent):void
		{
			dispatchEvent(e);
		}
		
		private var initHandlerHasRun:Boolean;
		/* Facebook Handlers */
		private function initHandler(success:Object,fail:Object):void
		{
			if(success is FacebookSession) {
				Facebook.api("/me/feed", submitPostHandler, getMessageObject(), "POST");
				postHasBeenCalled = true;
			} else {				
				Facebook.login(loginHandler,{perms:"read_stream,publish_stream"});
			}
			initHandlerHasRun = true;
			
		}
		private var postHasBeenCalled:Boolean;
		private function loginHandler(success:Object,fail:Object):void
		{
			if(success && !postHasBeenCalled){
				Facebook.api("/me/feed", submitPostHandler, getMessageObject(), "POST");
				postHasBeenCalled = true;
			} else if(fail){
				var node:XML = model.configXML.errorMessages.message.(@id=="facebookLoginError")[0];
				showModalAlert(String(node), "alert", node.@title); 
			}
		}
		private function loginPromptHandler(session:Object = null, obj2:Object = null):void{
		if(session && !postHasBeenCalled && initHandlerHasRun && session.status == "connected") {
			var fb:FacebookSession = Facebook.getSession();
			//Had to incorporate a delay here to avoid an IO Error and failed post
			postHasBeenCalled = true;
			TweenLite.delayedCall(1, postToFB);
			//Facebook.api("/me/feed", submitPostHandler, getMessageObject(), "POST");
			//postHasBeenCalled = true;
		} else if(obj2){
			var node:XML = model.configXML.errorMessages.message.(@id=="facebookLoginError")[0];
			showModalAlert(String(node), "alert", node.@title); 
		}
		}
		
		private function postToFB():void
		{
			Facebook.api("/me/feed", submitPostHandler, getMessageObject(), "POST");
		}
		
		private function submitPostHandler(result:Object,fail:Object):void
		{
			var node:XML;
			if(result) {
				dispatchEvent( new AnalyticEvent(AnalyticEvent.SHARE_WITH_FACEBOOK_SUCCESS));
				 node = model.configXML.messages.message.(@id=="facebookPostOK")[0];
				 showModalAlert(String(node), "alert", node.@title);
			} else if(fail) {
				node = model.configXML.errorMessages.message.(@id=="facebookPostError")[0];
				showModalAlert(String(node), "alert", node.@title);
			}
			postHasBeenCalled = false;
		}
		
		private function getMessageObject():Object
		{
			//trace('submitted id', model.submittedStatement.id);
			var o:Object = {};
			var node:XML = model.configXML.share.(@type=="facebook")[0];
			o.message = model.submittedStatement.message;
			o.title = node.title;
			o.link =String(config.params.pageURL)+"?statementId="+model.submittedStatement.id;
			o.name = node.link.@name;
			o.picture = node.@image;
			o.description = node.description;
			return o;
		}
		
		
		//Interstitial Ad Handlers
		private function interstitalHandler(e:ServiceEvent):void
		{
			model.adUnit = e.data.vo;
			model.showInterstitial = true;
			dispatchEvent(e);
		}
		private function interstitalErrorHandler(e:ServiceEvent):void
		{
			//dispatchEvent(e.data.forwardEvent);
			trace("Interstitial Ad Error");
		}
		
		
		
		//Add New Statement Handlers
		private function submitPendingHandler(e:ServiceEvent):void
		{
			dispatchEvent(e);
		}
		private function submitSuccessHandler(e:ServiceEvent):void
		{
			model.submitCount++;
			model.submittedStatement = e.data as StatementVO;
			ads.addEventListener(ServiceEvent.INTERSTITIAL_AD_LOADED, interstitalHandler);
			ads.addEventListener(ServiceEvent.INTERSTITIAL_AD_ERROR, interstitalErrorHandler);
			ads.getInterstitalAd(e);
			dispatchEvent(e);
		}
		private function submitErrorHandler(e:ServiceEvent):void
		{
			var node:XML = model.configXML.errorMessages.message.(@id=="addStatementError")[0];
			showModalAlert(node, "alert", node.@title);
			dispatchEvent(e);
		}
		
		//Get a statement list
		private function statementListLoadingHandler(e:ServiceEvent):void
		{
			/*var node:XML = model.configXML.messages.message.(@id=="listLoading")[0];
			showModalAlert(node, "roadblock", node.@title);*/
			dispatchEvent(e);
		}
		private function statementListLoadedHandler(e:ServiceEvent):void
		{
			model.statementCollection = new ArrayCollection(e.data as Array);
			/*if(modal) {
				PopUpManager.removePopUp(modal);
			}*/
		}
		private function statementListErrorHandler(e:ServiceEvent):void
		{
			var node:XML = model.configXML.errorMessages.message.(@id=="statementListError")[0];
			showModalAlert(node, "alert", node.@title);
			dispatchEvent(e);
		}
		
		//Get a single statement
		private function statementLoadingHandler(e:ServiceEvent):void
		{
			dispatchEvent(e);
		}
		private function statementLoadedHandler(e:ServiceEvent):void
		{
			model.currentStatement = e.data as StatementVO;
			dispatchEvent(e);
		}
		private function statementUnavailableHandler(e:ServiceEvent):void
		{
			var node:XML = model.configXML.errorMessages.message.(@id=="statementUnavailable")[0];
			showModalAlert(node, "alert", node.@title);
		}
		
		private function statementErrorHandler(e:ServiceEvent):void
		{
			dispatchEvent(e);
			var node:XML = model.configXML.errorMessages.message.(@id=="statementUnavailable")[0];
			showModalAlert(node, "alert", node.@title);
		}
		
		//Facebook login service
		private function facebookUserLoadingHandler(e:ServiceEvent):void
		{
			
		}
		private function facebookUserLoadedHandler(e:ServiceEvent):void
		{
			model.currentUser = e.data as UserVO;
		}
		private function facebookUserNoneHandler(e:ServiceEvent):void
		{
			
		}
		private function facebookUserErrorHandler(e:ServiceEvent):void
		{
			
		}		
		
		//OCom User login services
		private function ocomUserLoadingHandler(e:ServiceEvent):void
		{
			
		}
		private function ocomUserLoadedHandler(e:ServiceEvent):void
		{
			model.currentUser = e.data as UserVO;
		}
		private function ocomUserNoneHandler(e:ServiceEvent):void
		{
			
		}
		private function ocomUserErrorHandler(e:ServiceEvent):void
		{
			
		}				
		/* </Service Status/Result Handlers> */		
		public static function getInstance():Controller
		{
			if (! _instance)
			{
				_instance = new Controller(new SingletonEnforcer());
			}
			return _instance;
			
		}
		public function Controller(s:SingletonEnforcer){}
	}
}
class SingletonEnforcer{} 