package tv.own.gratitude.business
{
	import com.adobe.serialization.json.JSON;
	import com.gskinner.utils.Rndm;
	
	import flash.events.EventDispatcher;
	import flash.net.URLRequestMethod;
	
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.http.HTTPService;
	
	import tv.own.gratitude.events.ServiceEvent;
	import tv.own.gratitude.model.Model;
	import tv.own.gratitude.vo.StatementVO;
	import tv.own.gratitude.vo.UserVO;
	import tv.own.util.Random;
	import tv.own.vo.CountryListVO;
	
	[Event(name="getStatementListLoading", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getStatementListLoaded", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getStatementListError", type="tv.own.gratitude.events.ServiceEvent")]
	
	[Event(name="getStatementLoading", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getStatementLoaded", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getStatementError", type="tv.own.gratitude.events.ServiceEvent")]
	
	[Event(name="submitStatementLoading", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="submitStatementLoaded", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="submitStatementError", type="tv.own.gratitude.events.ServiceEvent")]
	
	[Event(name="getOcomUserLoading", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getOcomUserLoaded", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getOcomUserError", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getOcomUserNone", type="tv.own.gratitude.events.ServiceEvent")]
	
	[Event(name="getFacebookUserLoading", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getFacebookUserLoaded", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getFacebookUserError", type="tv.own.gratitude.events.ServiceEvent")]
	[Event(name="getFacebookUserNone", type="tv.own.gratitude.events.ServiceEvent")]
	
	
	
	public class Services extends EventDispatcher
	{
		private static var _instance:Services;
		
		private var model:Model = Model.getInstance();
		private var service:HTTPService;
		
		public static const DEBUG_CGI:String = "http://betastg.oprah.com/cgi-bin/statement.cgi";
		
		public function getUserInfo():void
		{
			service = new HTTPService();
			service.method = URLRequestMethod.POST;
			service.resultFormat = HTTPService.RESULT_FORMAT_E4X;
			service.url = model.gateway;
			service.showBusyCursor = true;
			service.addEventListener(ResultEvent.RESULT, getUserResultHandler);
			service.addEventListener(FaultEvent.FAULT, getUserFaultHandler);
			var params:Object = {};
			params.op = "get_user";
			params.auth = model.auth;
			//params.src_entity_id = model.src_entity_id;
			service.send(params);
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_OCOM_USER_LOADING));
		}
		
		public function getCountryList():void
		{
			service = new HTTPService();
			service.method = URLRequestMethod.POST;
			service.resultFormat = HTTPService.RESULT_FORMAT_E4X;
			service.url = model.gateway;
			service.showBusyCursor = true;
			service.addEventListener(ResultEvent.RESULT, getCountryListResultHandler);
			service.addEventListener(FaultEvent.FAULT, getCountryListFaultHandler);
			var params:Object = {};
			params.op = "country_list";
			params.auth = model.auth;
			service.send(params);
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_OCOM_USER_LOADING));
		}
		
		public function getStatements(type:String, limit:uint = 52, page:uint = 1):void
		{	
			service = new HTTPService();
			service.method = URLRequestMethod.POST;
			service.resultFormat = HTTPService.RESULT_FORMAT_E4X;
			service.url = model.gateway;
			service.showBusyCursor = true;
			service.addEventListener(ResultEvent.RESULT, statementListHandler);
			service.addEventListener(FaultEvent.FAULT, statementListFaultHandler);
			var params:Object = {};
			params.op = "list";
			params.auth = model.auth;
			params.per_page = limit;
			service.send(params);
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LIST_LOADING));
		}
		
		public function getStatement(id:uint):void
		{	
			service = new HTTPService();
			service.method = URLRequestMethod.POST;
			service.resultFormat = HTTPService.RESULT_FORMAT_E4X;
			service.url = model.gateway;
			service.showBusyCursor = true;
			service.addEventListener(ResultEvent.RESULT, statementResultHandler);
			service.addEventListener(FaultEvent.FAULT, statementFaultHandler);
			var params:Object = {};
			params.op = "get_statement";
			params.auth = model.auth;
			params.statement_id = id;
			service.send(params);
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LOADING));
		}
		
		public function submitStatement(vo:StatementVO):void
		{
			service = new HTTPService();
			service.method = URLRequestMethod.POST;
			service.resultFormat = HTTPService.RESULT_FORMAT_E4X;
			service.url = model.gateway;
			service.showBusyCursor = true;
			var params:Object = {};
			params.op = "add";
			params.auth = model.auth;
			var str:String = JSON.encode(parseStatementToObject(vo));
			params.data = str;
			service.addEventListener(ResultEvent.RESULT, submitStatementResultHandler);
			service.addEventListener(FaultEvent.FAULT, submitStatementFaultHandler);
			service.send(params);
			dispatchEvent(new ServiceEvent(ServiceEvent.SUBMIT_STATEMENT_LOADING));
		}
		
		
		
		/*  Result/Fault Handlers  */
		private function submitStatementResultHandler(e:ResultEvent):void
		{
			var xml:XML = new XML(e.result);
			if(xml.errcode =="ok"){
				var o:Object = JSON.decode(String(e.result.data).split("\n").join("").split("\t").join(""));
				var vo:StatementVO = this.parseStatementToVO(o);
				dispatchEvent(new ServiceEvent(ServiceEvent.SUBMIT_STATEMENT_LOADED,vo));
			} else {
				trace(xml.errcode);
				dispatchEvent(new ServiceEvent(ServiceEvent.SUBMIT_STATEMENT_ERROR));
			}
		}
		private function getUserResultHandler(e:ResultEvent):void
		{
			var xml:XML = new XML(e.result);
			if(xml.errcode =="ok"){
				var o:Object = JSON.decode(String(e.result.data).split("\n").join("").split("\t").join(""));
				var vo:UserVO = parseUserToVO(o.user);
				vo.type = UserVO.OCOM;
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_OCOM_USER_LOADED,vo));
			} else {
				trace(xml.errcode);
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_OCOM_USER_ERROR));
			}
		}
		
		private function getCountryListResultHandler(e:ResultEvent):void
		{
			var xml:XML = new XML(e.result);
			if(xml.errcode =="ok"){
				var result:Object = JSON.decode(String(e.result.data).split("\n").join("").split("\t").join(""));
				var arr:Array = [];
				for (var i:uint = 0; i<result.country_list.length; i++) {
					var vo:CountryListVO = parseCountryToVO(result.country_list[i] as Object, i);
					arr.push(vo);
				}	
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_COUNTRY_LIST_LOADED, arr));
			} else {
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_COUNTRY_LIST_ERROR));
			}
		}
		private function statementResultHandler(e:ResultEvent):void
		{
			var xml:XML = new XML(e.result);
			if(xml.errcode =="ok"){
				var o:Object = JSON.decode(String(e.result.data).split("\n").join("").split("\t").join(""));
				var vo:StatementVO = parseStatementToVO(o);
					dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LOADED, vo));
			} else {
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_UNAVAILABLE));
			}
		}
		private function statementListHandler(e:ResultEvent):void
		{
			var xml:XML = new XML(e.result);
			//trace("LIST result:");
			//trace(xml);
			if(xml.errcode =="ok"){
			var arr:Array = [];
			var result:Object = JSON.decode(String(e.result.data).split("\n").join("").split("\t").join(""));
			trace("LIST PARSING RESULT:", result.list.length, "ITEMS");
			for (var i:uint = 0; i<result.list.length; i++) {
				var vo:StatementVO = parseStatementToVO(result.list[i] as Object);
				var rdm:Number = Random.range(0, model.flakes.length-1); 
				vo.iconIndex = rdm;
				vo.icon = model.flakes[rdm];
				arr.push(vo);
			}
			trace("LIST:", arr.length, "VO ITEMS CREATED");
			if(arr.length) {				
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LIST_LOADED, arr));
			} else {
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LIST_NONE));	
			}
			} else {
				dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LIST_ERROR));	
			}
		}
		
		private function getCountryListFaultHandler(e:FaultEvent):void
		{
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_COUNTRY_LIST_ERROR));	
		}
		
		private function statementFaultHandler(e:FaultEvent):void
		{
			
		}
		
		private function statementListFaultHandler(e:FaultEvent):void
		{
			dispatchEvent(new ServiceEvent(ServiceEvent.GET_STATEMENT_LIST_ERROR));
		}
		
		
		private function getUserFaultHandler(e:FaultEvent):void
		{
			
		}
		
		private function submitStatementFaultHandler(e:FaultEvent):void
		{
			
		}
		
		
		
		/*
		Parsing functions
		*/
		private function parseUserToVO(o:Object):UserVO
		{
			var vo:UserVO = new UserVO(unescape(o.firstName), unescape(o.lastName), unescape(o.city), unescape(o.state), o.country, o.id, o.userName);
			vo.countryIndex = getCountryIndexFor(o.country)==-1?vo.countryIndex:getCountryIndexFor(o.country);
			return vo;
		}
		private function parseCountryToVO(o:Object, index:uint):CountryListVO
		{
			return new CountryListVO(index, o.countryName, o.country_code);
		}
		private function parseStatementToVO(o:Object):StatementVO
		{
			return new StatementVO(parseUserToVO(o.user), unescape(o.message), o.creationDate, o.statementId);
		}
		private function parseUserToObject(o:UserVO):Object
		{
			var obj:Object = {};
			obj.firstName = escape(o.firstName);
			obj.lastName = escape(o.lastName);
			obj.city = escape(o.city);
			obj.state = escape(o.state);
			obj.country = o.country;
			obj.id = o.id;
			return obj;
		}
		private function parseStatementToObject(vo:StatementVO):Object
		{
			var o:Object = {};
			o.message = escape(vo.message);
			o.user = parseUserToObject(vo.user);
			o.statementId = vo.id;
			return o;
		}
		
		private function getCountryIndexFor(code:String=""):int
		{
			//trace("getting index for", code, "::", model.countryList.length, "Countries");
			var i:int = 0;
			if(!code || code == "" || code == "USA") {
				return 0;
			}
			for(var j:uint = 0; j<model.countryList.length; j++) {
				var vo:CountryListVO = model.countryList.getItemAt(j) as CountryListVO;
				if(code.toLowerCase() == vo.name.toLowerCase() || code.toLowerCase() == vo.code.toLowerCase()) {
					i = j;
					//trace(node, node.@code);
					break;	
				}
			}
			//trace("setting countryIndex as", i);
			return i;
		}
		
		
		public static function getInstance():Services
		{
			if (! _instance)
			{
				_instance = new Services(new SingletonEnforcer());
			}
			return _instance;
			
		}
		public function Services(s:SingletonEnforcer){}
	}
}
class SingletonEnforcer{}  