package tv.own.gratitude.business
{
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	import tv.own.gratitude.events.ServiceEvent;
	import tv.own.util.AdTagParserUtil;
	import tv.own.vo.AdUnitVO;

	public class AdManager extends CoreManager
	{
		private var _forwardEvent:ServiceEvent;
		
		public function AdManager()
		{
			super();
		}
		
		
		public function getInterstitalAd(e:ServiceEvent):void
		{
			_forwardEvent = e;
			var path:String = String(model.configXML.sponsors.@interstital);
			if(path && path.length>0) {
			var rdm:Number = new Date().getTime();
			var uloader:URLLoader = new URLLoader();
			var req:URLRequest = new URLRequest(path);
			uloader.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
			uloader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorHandler);
			uloader.addEventListener(Event.COMPLETE, completeHandler);
			uloader.load(req);
			var evt:ServiceEvent = new ServiceEvent(ServiceEvent.INTERSTITIAL_AD_LOADING);
			dispatchEvent(evt);
			} else {
				errorHandler(null);
			}
		}
		
		private function completeHandler(e:Event):void
		{
			var vo:AdUnitVO = AdTagParserUtil.parseAdXMLToVO(String(e.target.data));
			if(vo.imageURL && vo.exitURL) {
				var data:Object = {vo:vo, fowardEvent:_forwardEvent};
				var evt:ServiceEvent = new ServiceEvent(ServiceEvent.INTERSTITIAL_AD_LOADED, data);
				dispatchEvent(evt);
			} else {
				errorHandler(null);
			}
		}
		
		private function errorHandler(e:ErrorEvent):void
		{
			var data:Object = {fowardEvent:_forwardEvent};
			var evt:ServiceEvent = new ServiceEvent(ServiceEvent.INTERSTITIAL_AD_ERROR, data);
			dispatchEvent(evt);
		}
		
		
		
	}
}